require( "quest/m2_farm/convout.lua" );
combine_speech_tables();

bus_speed = 5;

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

function flo_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("visited_chicken_chorus") < 1 then
		run_super_conversation(flo, "quip_farm_A");
	elseif not quest_complete("pass_chickenchorus") then
		run_super_conversation(flo, "quip_farm_B");
	else
		scene.DANIEL:StartProc(daniel_talk);
		run_super_conversation(flo, "quip_farm_C");
		scene.DANIEL:StartProc(daniel_idle);
	end;
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetWalkSpeed(flo_speed);
		
		actor:FaceNow(DIR.W);
		
		local lastScene = game:GetLastScene();
		
		--if lastScene == "m2_sizzle2" then
			
			
		if lastScene == "mg_chickenchorus" or lastScene == "mg_chickenfield" then
			actor:JumpToNamedPoint("coop");
			if game:Get("mg_chickenchorus_activity_round") > 1  then
				if not quest_complete("pass_chickenchorus") then
					wait_fade();
					
					--BAG_INV:RemoveInventory("egg");
					--addInventory(inv_desc_eggs);
					actor:WalkTo("flo");
					wait_walkto();
					
					scene.DANIEL:StartProc(daniel_talk);
					run_super_conversation(actor, "conv_daniel_D");
					scene.DANIEL:StartProc(daniel_idle);
					complete_quest("pass_chickenchorus", false);
					complete_quest("get_eggs", false);
					add_quest("use_eggs");
				end;
			else
				actor:WalkTo("flo");
				wait_walkto();
				wait_fade();
				scene.DANIEL:StartProc(daniel_talk);
				run_super_conversation(actor, "conv_daniel_C");
				scene.DANIEL:StartProc(daniel_idle);
			end;
		else
		--Get off bus
			actor:JumpToNamedPoint("bus_walkto");
			flo_bus = scene:Spawn(flo_bus_spec);
			actor:SetAlpha(0);
			
			move_actor_x(flo_bus, 500);
			move_actor_x(scene.BUS, 500);
			move_actor_x(scene.ERNIE, 500);
			move_actor_x(scene.BUS_WINDOWS, 500);
			move_actor_x(scene.BUS_TYRES, 500);
			scene.BUS_TYRES:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			scene.BUS_TYRES:PlayAnim("DoWalkW");
			
			local dist = 500;
			local speed = -2;
			
			sfx:PlaySFX("audio/sfx/bus_park");
			
			while dist > 0 do
				move_actor_x(flo_bus, speed);
				move_actor_x(scene.BUS, speed);
				move_actor_x(scene.ERNIE, speed);
				move_actor_x(scene.BUS_WINDOWS, speed);
				move_actor_x(scene.BUS_TYRES, speed);
				scene.BUS_TYRES:SetWalkSpeed(-speed);
				dist = dist + speed;
				delay(1);
			end
			
			scene.BUS_TYRES:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			scene.BUS_TYRES:PlayAnim("DoStandW");
			
			flo_bus:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			flo_bus:PlayAnim("LeaveBus");
			wait_anim(flo_bus);
			flo_bus:Expire();
			actor:JumpToNamedPoint("bus_walkto");
			actor:SetAlpha(1);
			actor:WalkTo("flo");
			wait_walkto();
			
			--Play intro
			if game:Get("first_time_farm") < 1 then
				coroutine.yield(RESUME.ON_CLICK);
				scene.DANIEL:StartProc(daniel_talk);
				run_super_conversation(actor, "conv_daniel_intro");
				scene.DANIEL:StartProc(daniel_idle);
				complete_quest("check_farm", false);
				add_quest("pass_chickenchorus");
				game:Set("first_time_farm", 1);
			end;
		
		--[[
			actor:JumpToNamedPoint("coop");
			actor:WalkTo("flo");
			wait_walkto();]]
		end;
		
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(flo_conv);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function gotocoop(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:Get("visited_chicken_chorus") < 1 then
		run_super_conversation(flo, "quip_barn");
	end
	flo:WalkTo("coop");
	wait_walkto();
	
	if not quest_added("pass_chickenfield") or quest_complete("pass_chickenfield") then
		goto_scene(flo, "mg_chickenchorus");
	else
		goto_scene(flo, "mg_chickenfield");
	end
end

to_coop_spec = 
{	
	name = "TO_COOP";
	halo = "to_coop";
	cursor = "cursor_arrow_n";
	goto_fn = gotocoop;
}

function click_on_bus(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if game:Get("visited_chicken_chorus") < 1 then
		run_super_conversation(flo, "quip_bus_A");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		scene.DANIEL:StartProc(daniel_talk);
		if not quest_complete("pass_chickenchorus") then
			run_super_conversation(flo, "quip_bus_B");
		else
			run_super_conversation(flo, "quip_bus_C");
		end
		scene.DANIEL:StartProc(daniel_idle);
		flo_ridebus(flo);
	end
end

function click_on_bus_token(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if game:Get("visited_chicken_chorus") < 1 then
		run_super_conversation(flo, "quip_bus_A");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		--scene.DANIEL:StartProc(daniel_talk);
		run_super_conversation(flo, "quip_use_token_B");
		--scene.DANIEL:StartProc(daniel_idle);
		flo_ridebus(flo);
	end
end

local bus_depth = 510;
local bus_start = { x = -400, y = 50 };
local bus_tyres_start = { x = -400+900, y = 50+250 };

bus_spec =
{
	name = "BUS";
	gfx = { anim = "anim/bus/bus" };
	halo = "quest/objects/bus";
	
	command = function(actor)
		--actor:JumpToNamedPoint("busposa");
		actor:JumpToPoint(bus_start);
		actor:SetDepthValue(bus_depth);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(bus_speed);
		actor:FaceNow(DIR.W);
	end;
	
	on_arrive = function(flo, bus)
		flo:FaceActor(bus);
		flo:StartProc(click_on_bus);
	end;
	
	on_use_inv = function(item, flo, bus)
		if item == "token" then
			flo:StartProc(click_on_bus_token);
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE.INV_UNHANDLED;
		end
	end;
	
	on_arrive = function(flo, ernie)
		flo:StartProc(click_on_bus);
	end;
}

bus_tyres_spec =
{
	name = "BUS_TYRES";
	gfx = { anim = "anim/bus/tyres" };
	
	command = function(actor)
		actor:JumpToPoint(bus_tyres_start);
		actor:SetDepthValue(bus_depth-5);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(bus_speed);
		actor:FaceNow(DIR.W);
	end;
}

bus_windows_spec = 
{
	name = "BUS_WINDOWS";
	gfx = { image = "window_overlay" };
	
	command = function(actor)
		actor:JumpToPoint { x = -400, y = 50 };
		actor:SetDepthValue(520);
		actor:SetWalkSpeed(bus_basespeed);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	end;
}

ernie_bus_spec =
{
	name = "ERNIE";
	gfx = { anim = "anim/ernie/board_bus2" };
	
	command = function(actor)
		prepare_actor_text(actor, ernie_bus_text_spec);
		actor:JumpToNamedPoint("ernie");
		actor:SetDepthValue(490);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(bus_speed);
		actor:FaceNow(DIR.W);
	end;
}

flo_bus_spec =
{
	name = "FLO_BUS";
	gfx = { anim = "anim/flo/bus" };
	
	command = function(actor)
		--actor:JumpToNamedPoint("busposa");
		actor:JumpToPoint { x = -400, y = 50 };
		actor:SetDepthValue(510);
		actor:SetWalkSpeed(bus_basespeed);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:FaceNow(DIR.E);
	end;
}

flo_ridebus = function(flo)
	flo:WalkTo("bus_walkto");
	wait_walkto();
	flo:SetAlpha(0);
	
	flo_bus = scene:Spawn(flo_bus_spec);
	scene.FLO_BUS:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	sfx:PlaySFX("audio/sfx/bus_start");
	scene.FLO_BUS:PlayAnim("BoardBus");
	wait_anim(scene.FLO_BUS);
	
	scene.FLO_BUS:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.FLO_BUS:PlayAnim("DoStandE");
	
	delay(20);
	
	scene.BUS_TYRES:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	scene.BUS_TYRES:PlayAnim("DoWalkW");
	
	local dist = 1000;
	local speed = -2;
	local accel = -0.05;
	local fadeout = 100;
	
	while dist > 0 do
		move_actor_x(flo_bus, speed);
		move_actor_x(scene.BUS, speed);
		move_actor_x(scene.ERNIE, speed);
		move_actor_x(scene.BUS_WINDOWS, speed);
		move_actor_x(scene.BUS_TYRES, speed);
		scene.BUS_TYRES:SetWalkSpeed(-speed);
		dist = dist + speed;
		speed = speed + accel;
		fadeout = fadeout - 1;
		
		if fadeout == 0 then
			goto_scene(scene.FLO_BUS, "m2_sizzle2");
		end
		delay(1);
	end
end;

daniel_anim_table =
{
	"anim/daniel/stand",
	"anim/daniel/talke",
	"anim/daniel/idle1",
	"anim/daniel/idle2",
	"anim/daniel/idle3",
};

function daniel_idle(daniel)
	while true do
		delay(math.random(150, 200));
		if math.random(1,3) == 2 then
			daniel:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
			daniel:PlayAnim("Idle1");
			wait_anim();
			
			daniel:PlayAnim("Idle2");
			wait_anim();
			
			daniel:PlayAnim("Idle3");
			wait_anim();
			daniel:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		end
	end
end

function daniel_talk(daniel)
	daniel:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	daniel:PlayAnim("DoStandE");
end

function daniel_conv(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DANIEL:StartProc(daniel_talk);
	if game:Get("visited_chicken_chorus") < 1 then
		local conv_daniel_num = game:Get("conv_daniel_num");
		--alternate conversations
		if conv_daniel_num < 1 then
			conv_daniel_num = 1;
		end
		
		if conv_daniel_num == 1 then
			run_super_conversation(flo, "conv_daniel_A");
			conv_daniel_num = 2;
		else
			run_super_conversation(flo, "conv_daniel_B");
			conv_daniel_num = 1;
		end
		
		game:Set("conv_daniel_num", conv_daniel_num);
	elseif not quest_complete("pass_chickenchorus") then
		run_super_conversation(flo, "conv_daniel_B");
	else
		run_super_conversation(flo, "conv_daniel_E");
	end;
	scene.DANIEL:StartProc(daniel_idle);
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

daniel_spec = 
{
	name = "DANIEL";
	halo = "quest/objects/danielw";
	anim = daniel_anim_table;
	
	command = function(actor)
		actor:JumpToNamedPoint("daniel");
		prepare_actor_text(actor, daniel_text_spec);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		
		actor:FaceNow(DIR.E);
		
		actor:StartProc(daniel_idle);
		
		--actor:PlayAnim("stand");
	end;
	
	on_arrive = function(flo, daniel)
		flo:FaceActor(daniel);
		flo:StartProc(daniel_conv);
	end;
	
	on_use_inv = function(item, flo, daniel)
		flo:FaceActor(daniel);
		return RESPONSE.INV_UNHANDLED;
	end;
	
};

cow_spec = 
{
	name = "COW";
	anim = "anim/m2_farm/cow";
	halo = "farm_cow";
	
	command = function(actor)
		actor:SetDepthValue(10);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Chew");
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(function(flo)
			flo:SetMode(MODE.CUTSCENE);
			flo:Face(DIR.E);
			delay(15);
			run_super_conversation(flo, "quip_farm_cow");
			flo:Face(DIR.W);
			flo:SetMode(MODE.FOLLOWCLICKS);
		end);
	end
};

sheep_spec = 
{
	name = "SHEEP";
	anim = "anim/m2_farm/sheep";
	halo = "farm_sheep";
	
	command = function(actor)
		actor:SetDepthValue(10);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Chew");
		actor:SetScaleX(-0.8)
		actor:SetScaleY(0.8)
		actor:JumpToPoint { x = 1016, y = 33 };
		--actor:JumpToPoint{x = -45, y = 0 };
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(function(flo)
			flo:SetMode(MODE.CUTSCENE);
			flo:Face(DIR.E);
			delay(15);
			run_super_conversation(flo, "quip_farm_sheep");
			flo:Face(DIR.W);
			flo:SetMode(MODE.FOLLOWCLICKS);
		end);
	end
};

farm_sign_spec = 
{
	name = "FARM_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/kristen_itc.mvec",
			color = { a = 1, r = 0.04, g = 0.07, b = 0.04 },
			outline_size = 0,
			lineheight = 20,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_farm_sign");
		actor:StopWalking();
		actor:SetPolygon({x=146,y=165}, {x=332,y=227}, {x=151,y=195}, {x=335,y=260});
		actor:TextToImage(50, 0);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_farm.ogg", true);
		scene:SetRoomScale(300, 550, 0.3, 1.0);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data

		end
		
		if game:Get("mg_chickenchorus_activity_round") <= 1 then
			spawn_nav_arrow(to_coop_spec);
		end
		
		game:Set("visited_farm", 1);
		
		spawn_simple_hotspot("farm_fruit", 5);
		
		game:SetString("map_position", "m2_farm");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "fence", 450 },
		{ "mask_bananas", 500 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		scene_setup,
		bus_spec,
		bus_tyres_spec,
		bus_windows_spec,
		ernie_bus_spec,
		daniel_spec,
		cow_spec,
		sheep_spec,
		farm_sign_spec,
		
		flo_spec, -- the main actor
	};
};
